package org.bm.p2p.navigablep2p;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Graph {
	private ArrayList<Node> nodes ;
	public ArrayList<Node> getNodes() {
		return nodes;
	}

	public void setNodes(ArrayList<Node> nodes) {
		this.nodes = nodes;
	}
	private static final int MAXMESSAGES = Node.BUCKETS * Node.BUCKETS ;

	//ʼ磬ڵΪ0
	public Graph() {
		super();
		nodes = new ArrayList<Node> ();
	}
	
	//ʼ磬ڵΪsizeڵ֮ûб߽
	public Graph(int size) {
		super();
		nodes = new ArrayList<Node> ();
		for(int i = 0; i<size; i++) {
			System.out.print(i+": ");
			nodes.add(new Node());
		}
	}

	//ģBootStrapƣоѡһڵ㷵
	public Node bootstrap() {
		Random random = new Random();
		if (nodes.size()>0) {
			int chosedNodeIdx = random.nextInt(nodes.size());
			return nodes.get(chosedNodeIdx);
		}
		return null;
	}
	
	//ʼĵһڵ
	public void initializeTheFirstNode(Node node) {
		nodes.add(node);
	}
	
	// ڵnode跢͵Ϣ
	public int addNode2(Node node) {
		int messageNum = 0; //һڵ跢͵Ϣ
		Node bootstrapNode2 = bootstrap(); 
		for (int i = 0; i < Node.BUCKETS; i++) {
			// һͽڵnodeľΪi½ڵrandomDestNode
			// Node randomDestNode = new Node(node,i);
			// ڵrandomDestNodeΪĿڵ㣬bootstrapNodeʼ·ɵrandomDestNode
			// мڵڵnodeĳھӣڵnodeЩмڵھ
			// мڵΪգмڵھѾڣ
			// Ѿ֪ĳڵھӺͳھӣͿڵھӺͳھӵľ
			
			Node bootstrapNode = bootstrap(); // bootstrapڵ
			int maxDestNodeNum = 2; // ÿηĿڵ
			//ϵڵbootstrapNodeʼڵnodeľΪiĽڵ
			//ϵڵbootstrapNodeͼڵľi
			while ((bootstrapNode!=null) && (node.getDistanceFrom(bootstrapNode)> i)) {
				bootstrapNode = bootstrapNode.getOutNeighbor(node.getDistanceFrom(bootstrapNode));
				messageNum ++;
			}
			if ((bootstrapNode!=null)&& (node.getDistanceFrom(bootstrapNode)<i)) {
				bootstrapNode = bootstrapNode.getOutNeighbor(i);
				messageNum ++;
			}
			if ((bootstrapNode!=null)&&(node.getDistanceFrom(bootstrapNode) == i)) { //ϵڵͼڵľ=i
				//кϵڵľСiĽڵ㣬Щڵͼڵľ붼i
				//һȵ㷨
				Queue<Node> visitedNodes = new LinkedList<Node> ();
				visitedNodes.add(bootstrapNode); // ϵڵѷʽڵ
				int destNodeNum = 0; // ѷʵĽڵ
				// ֻҪѷʽڵûдﵽmaxDestNodeNumңѷʽڵвΪ
				while ((destNodeNum<=maxDestNodeNum)&&(visitedNodes.size()>0)) {
					//ѷʽڵȡһڵ
					Node hasVisitedNode = visitedNodes.remove();
					//ýڵľΪiĳھΪգͰѼڵnodeΪýڵΪiĳھ
					if (hasVisitedNode.getOutNeighbor(i) == null) {
						hasVisitedNode.setOutNeighbor(node, i);
						node.setInNeighbor(hasVisitedNode, i);
						//maxDestNodeNum = 10000;
					}
					// ýڵΪڵnodeĳھ
					node.setOutNeighbor(hasVisitedNode, i);
					hasVisitedNode.setInNeighbor(node, i);
					
					// ִstolen linkhasVisitedNodeһھӽڵ㣬ڵʱԽھԽࡱ
//					for (int k = i+1; k < Node.BUCKETS; k++) {
//						if (hasVisitedNode.getInNeighbor(k)!=null) {
//							hasVisitedNode.getInNeighbor(k).setOutNeighbor(node, k);
//							node.setInNeighbor(hasVisitedNode.getInNeighbor(k), k);
//						}
//					}
					
					destNodeNum ++;
					messageNum ++;
					// ʺͽڵhasVisitedNodeľСiнڵ
					for (int j = i - 1; j >= 0; j--) {
						if (hasVisitedNode.getOutNeighbor(j) != null) {
							visitedNodes.add(hasVisitedNode.getOutNeighbor(j));
						}
					}
					
				}
				
			}
		}
		nodes.add(node);
		return messageNum;
	}
	
	// ɾڵ㣬跢͵Ϣ
	// ɾڵھӽڵĳھñɾڵĳھ
	public int delNode(Node node) {
		int messageNum = 0;
		// ɾڵھӽڵбеھ
		int j = 0;
		for (int i = 0; i <= Node.BUCKETS - 1; i++) {
			if (node.getInNeighbor(i) != null) {
				for (int k = j; k <= i; k++) {
					if (node.getOutNeighbor(k) != null) {
						node.getInNeighbor(i).setOutNeighbor(node.getOutNeighbor(k),i);
						messageNum ++;
						break;
					}
				}
				j = i;
			}
		}
		return messageNum;
	}
	
	public void delNodes() {
		for (int i = 0; i < nodes.size(); i ++) {
			Random random = new Random();
			int chosenNodeIdx = random.nextInt(nodes.size());
			int messageNum = delNode(nodes.get(chosenNodeIdx));
			System.out.println("delNode messageNum: " + messageNum);
			nodes.remove(chosenNodeIdx);
			testRoute();
		}
	}
	/**
	 * ڵnode磬ʹRandom WalkΪڵnodeӱ
	 * 
	 * ڵaһھӽڵbڵcǽڵbĳھӽڵ㣬ô
	 * (1) If D(b,c)=D(a,b), Then D(a,c)<D(a,b)
	 * (2) If D(b,c)>D(a,b), Then D(a,c)=D(b,c)>D(a,b)
	 * (3) If D(b,c)<D(a,b), Then D(a,c)=D(a,b)
	 * 
	 * ͨ»ƻNextHops:
	 * (1): ԽڵcΪNextHop
	 * (2): ѡڵcΪNextHop
	 * (3): ڵ룬ֹͣ
	 */
	/*
	public void addNode(Node node) {
		Node bootstrapNode = bootstrap(); // bootstrapڵ
		//int maxSteps = Node.BUCKETS; // ?
		int maxDistance = Node.BUCKETS-1, 
		minDistance = 0;
		int messageNumber = randomWalk(maxDistance, minDistance, node, bootstrapNode, 0);
		System.out.println("messages: " + messageNumber);
		nodes.add(node);
	}
	
	private int randomWalk(int maxDistance, int minDistance, Node joinNode, Node concactNode, int messageNumber) {
		if (messageNumber++ > MAXMESSAGES) return messageNumber;
		
		// üڵϵڵľ
		int curDistance = joinNode.getDistanceFrom(concactNode);
		// 洢 ϵڵھ ڵľ ϵڵڵľ ȵĽڵ
		ArrayList<Node> distanceEqualsNodes = new ArrayList<Node> ();
		// ϵڵ
		distanceEqualsNodes.add(concactNode);
		// ϵڵھеͬڵ
		for (int i = curDistance - 1; i>=0;i--) {
			if (concactNode.getOutNeighbor(i) != null) 
				distanceEqualsNodes.add(concactNode.getOutNeighbor(i));
		}
		// ͬڵбѡһڵ
		Random random = new Random();
		int chosedNodeIdx = random.nextInt(distanceEqualsNodes.size());
		//ýڵ뵽ڵھӽڵ
		joinNode.setOutNeighbor(distanceEqualsNodes.get(chosedNodeIdx), curDistance);
		//ҪҪڵýڵھأ
		distanceEqualsNodes.get(chosedNodeIdx).setOutNeighbor(joinNode, curDistance);
		
		//ѡһڵ㣬ڵСcurDistanceĽڵ㣨ֻһ
		Node distanceLessNode = concactNode.getOutNeighbor(curDistance);
		if (distanceLessNode!=null && !distanceLessNode.equals(joinNode)) { // && joinNode.getDistanceFrom(distanceLessNode) >= minDistance
			messageNumber = randomWalk(maxDistance, minDistance, joinNode, distanceLessNode, messageNumber); //curDistance-1
		}
		
		//ѡһڵ㣬ڵcurDistanceĽڵ
		ArrayList<Node> distanceLargerNodes = new ArrayList<Node> ();
		for (int i = curDistance + 1; i <= maxDistance;i++) {
			if (concactNode.getOutNeighbor(i) != null) 
				distanceLargerNodes.add(concactNode.getOutNeighbor(i));
		}
		if (distanceLargerNodes.size()>0) {
			random = new Random();
			chosedNodeIdx = random.nextInt(distanceLargerNodes.size());
			messageNumber = randomWalk(maxDistance,minDistance , joinNode, distanceLargerNodes.get(chosedNodeIdx), messageNumber); //curDistance+1
		}
		return messageNumber;
	}
	
	private int randomWalk2(int maxDistance, int minDistance, Node joinNode, Node concactNode, int messageNumber) {
		if (messageNumber++ > MAXMESSAGES) return messageNumber;

		// üڵϵڵľ
		int curDistance = joinNode.getDistanceFrom(concactNode);
		// 洢 ϵڵھ ڵľ ϵڵڵľ ȵĽڵ
		ArrayList<Node> distanceEqualsNodes = new ArrayList<Node> ();
		// ϵڵ
		distanceEqualsNodes.add(concactNode);
		// ϵڵھеͬڵ
		for (int i = curDistance - 1; i>=0;i--) {
			for (int j = 0; j < Node.K; j++) {
				if (concactNode.getOutNeighborByIdx(i,j) != null) 
					distanceEqualsNodes.add(concactNode.getOutNeighborByIdx(i,j));
			}
		}
		// ͬڵбѡKڵ
		if (distanceEqualsNodes.size()>Node.K) {
			for (int i = 0; i < Node.K; i++) {
				Random random = new Random();
				int chosedNodeIdx = random.nextInt(distanceEqualsNodes.size());
				//ýڵ뵽ڵھӽڵ(ܳͬĽڵ!)
				joinNode.setOutNeighbor(distanceEqualsNodes.get(chosedNodeIdx), curDistance);
				//ҪҪڵýڵھأ
				distanceEqualsNodes.get(chosedNodeIdx).setOutNeighbor(joinNode, curDistance);
			}
		}
		else {
			for (int i = 0; i < distanceEqualsNodes.size(); i++) {
				//ýڵ뵽ڵھӽڵ(ܳͬĽڵ!)
				if (!joinNode.equals(distanceEqualsNodes.get(i))) {
					joinNode.setOutNeighbor(distanceEqualsNodes.get(i), curDistance);
					//ҪҪڵýڵھأ
					distanceEqualsNodes.get(i).setOutNeighbor(joinNode, curDistance);
					
				}
			}
		}
		
		//ѡһڵ㣬ڵСcurDistanceĽڵ㣨ֻһ
		for (int i = 0; i < Node.K; i++) {
			Node distanceLessNode = concactNode.getOutNeighborByIdx(curDistance,i);
			if (distanceLessNode!=null && !distanceLessNode.equals(joinNode)) { // && joinNode.getDistanceFrom(distanceLessNode) >= minDistance
				messageNumber = randomWalk2(maxDistance, minDistance, joinNode, distanceLessNode, messageNumber); //curDistance-1
			}
		}
		
		//ѡһڵ㣬ڵcurDistanceĽڵ
			
		ArrayList<Node> distanceLargerNodes = new ArrayList<Node> ();
		for (int i = curDistance + 1; i <= maxDistance;i++) {
			for (int j = 0; j < Node.K; j++) {
				if (concactNode.getOutNeighborByIdx(i,j) != null) 
					distanceLargerNodes.add(concactNode.getOutNeighborByIdx(i,j));
				}
		}
		if (distanceLargerNodes.size()>0) {
			//Random random = new Random();
			//chosedNodeIdx = random.nextInt(distanceLargerNodes.size());
			for (int i = 0; i < distanceLargerNodes.size() ;i++) {
				messageNumber = randomWalk2(maxDistance,minDistance , joinNode, distanceLargerNodes.get(i), messageNumber); //curDistance+1
			}
		}
		return messageNumber;
	}
*/
	
	//ΪӱߣKlernbergNavigable Networkģ(ʽ㷨)
	public void addEdgesAccordingToDistance() {
		ArrayList<Node> someNodes = new ArrayList<Node> ();
		for(Node node : nodes) { //ÿڵ
			for(int i = 0; i<Node.BUCKETS;i++) { // ΪýڵÿͰһھӽڵ
				someNodes.clear();
				for(Node node2:nodes) { // ڵѡȡýڵΪiĽڵ㼯
					//ڵ㲻ȣҽڵΪi
					if (!node.equals(node2)&&(node.getDistanceFrom(node2)==i)) {
						someNodes.add(node2);
					}
				}
				if (someNodes.size() > 0)	{ //ڵ㼯ϲΪ
					System.out.print(i + " ");
					// ӾΪiĽڵ㼯ѡȡһڵ(?ģ͸ӦΪ1/2^i)
					Random random = new Random();
					int chosedNodeIdx = random.nextInt(someNodes.size());
					// ѡȡĽڵ뱾ڵھӽڵб
					node.setOutNeighbor(someNodes.get(chosedNodeIdx), i);//  (˴Ҳ԰someNodesĳȷڵھӽڵ㣬ܻ·ȵķ)
				}
				System.out.println();
								
			}
		}
	}
	
	// ྶ·,ʵ?	
	public int multiPathRoute(Node srcNode, Node destNode, int maxSteps) {
		int steps = 0;
		
		return  steps;
	}
	
	// ĽڵsrcNode·ɵڵdestNode·ɷν̰·(Greed Routing)
	// steps>0ʾ·ɳɹstepsĴС·,steps=-1ʾж,steps=0ʾmaxSteps
	// ·ͣҲһڵʱ1ʾʧܣ2ʾѡڶһڵ
	public int route(Node srcNode, Node destNode, int maxSteps, int routeType) {
		int steps = 0;
		// СmaxStepsԴڵ㻹ûеĿڵ㣬
		for(steps=0; steps <= maxSteps && ! srcNode.equals(destNode); steps++) {
			//ȡԴڵsrcNodeĿڵľ
			int distance = srcNode.getDistanceFrom(destNode);
			//srcNodeھӽڵиþھӣ
			if (srcNode.getOutNeighbor(distance) != null) {
				//ǰھӽڵ
				srcNode = srcNode.getOutNeighbor(distance);
			}
			else { //srcNodeھӽڵûиþھӣ
				if (routeType==1) // ·Ϊ1
					return -1; // -1ʾ·ʧ
				else if (routeType==2) { // ·Ϊ2
					// srcNodeľСdistanceĽڵѡȡһΪһڵ
					ArrayList<Node> distanceLessNodes = new ArrayList<Node> ();
					for (int i = distance-1; i>=0; i--) {
						if (srcNode.getOutNeighbor(i) != null)
							distanceLessNodes.add(srcNode.getOutNeighbor(i));
					}
					if (distanceLessNodes.size() > 0) { // ҵ
						Random random = new Random ();
						int nextNodeIdx = random.nextInt(distanceLessNodes.size());
						srcNode = distanceLessNodes.get(nextNodeIdx);
					}
					else { // ûҵsrcNodeľdistanceĽڵѡСĽڵ㣬Ϊһڵ
						int i;
						for (i = distance+1; i < Node.BUCKETS; i++) {
							if (srcNode.getOutNeighbor(i) != null)
								srcNode = srcNode.getOutNeighbor(i);
							break;
						}
						if (i == Node.BUCKETS) // ûҵ·ʧ 
							return -1;
					}
				}
			}
		}
		if (steps > maxSteps) return 0; // ·ȣ0ʾ·ʧ
		return steps; // 򣬷·
	}
	
	// ·ܣָ
	// 1·· 
	// 2·ʧܱ
	public void testRoute() {
		int steps = 0;
		double avgSteps = 0.0; // ƽ·
		double successPercent = 0.0; // ·ɳɹ
		
		int totalSteps = 0, //· 
			successNumber = 0, // ·ɳɹ
			totalNumber = 0; // ·ɴ
		for (Node srcNode : nodes) { // еÿڵ
			for (Node destNode : nodes) { // 㵽нڵ·
				if (srcNode.equals(destNode)) continue; //ԴڵĿڵͬһڵ㣬ͽѭ
				steps = route(srcNode,destNode,Node.BUCKETS*Node.BUCKETS,1);
				System.out.print(steps+" ");
				
				totalNumber ++; // ·ɴ1
				if (steps==0 || steps==-1) { // ·ʧ
				}
				else { // ·ɳɹ
					totalSteps += steps; // ·
					successNumber ++; // ·ɳɹ1
				}
			}
			System.out.println();
		}
		avgSteps = (double)totalSteps / successNumber; // ƽ· = · / ·ɳɹ
		successPercent = (double)successNumber / totalNumber * 100; // ·ɳɹ = ·ɳɹ / ·ɴ
		System.out.println("ƽ· = " + avgSteps);
		System.out.println("·ɳɹ = " + successPercent + "%");

	}
	
	// ṹļ
	public void output(String fileName) {
		PrintWriter fileOutput;
		try {
			fileOutput = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
			// нڵ
			for (int i = 0; i < nodes.size(); i++) {
				Node tmpNode = nodes.get(i);
				fileOutput.print(tmpNode.hashCode() + ", "+ tmpNode.getNodePosition().toString() + ": ");
				for (int j = 0; j < Node.BUCKETS; j++) {
					if (tmpNode.getOutNeighbor(j) != null) {
						//fileOutput.print(tmpNode.getOutNeighbor(j).hashCode()+", ");
						fileOutput.print(tmpNode.getOutNeighbor(j).getDistanceFrom(tmpNode)+", ");
						
					}
				}
				fileOutput.println();
			}
			fileOutput.close(); 
		} catch (IOException e) {
			System.err.println("Open graph.out ERROR!");
			e.printStackTrace();
		}

	}
	
	// жھӺͳھӵĸǷ
	public boolean isOutNeighborNumEqualsInNeighborNum() {
		boolean isEquals = true;
		
		for (int i = 0; i < nodes.size(); i++) {
			int inNeighborNum = 0, outNeighborNum = 0;
			Node itNode = nodes.get(i);
			for (int j = 0; j < Node.BUCKETS; j++) {
				if (itNode.getInNeighbor(j) != null) inNeighborNum ++;
				if (itNode.getOutNeighbor(j) != null) outNeighborNum ++;
			}
			System.out.println("inNeighborNum: " + inNeighborNum + " outNeighborNum: " + outNeighborNum);
			if (inNeighborNum > outNeighborNum) return false;
		}
		
		return isEquals;
	}
	
	public static void main(String[] argv) {
//		Graph graph = new Graph(1024);
//		graph.addEdgesAccordingToDistance();

		Graph graph = new Graph();
		graph.initializeTheFirstNode(new Node());
		for (int i =0;i<1024;i++) {
			int messageNum = graph.addNode2(new Node());
			System.out.println("messages: " + messageNum);
		}
		graph.testRoute();
		//graph.delNodes();
		graph.output("graph.out2");
		//System.out.println(graph.isOutNeighborNumEqualsInNeighborNum());
		
	}
}
